/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.nodes;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.epl.PHPEplPlugin;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org2.eclipse.php.internal.core.CoreMessages;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.scanner.AstLexer;
import org2.eclipse.php.internal.core.ast.scanner.php5.PhpAstParser;
import org2.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer;

public class ASTParser {
    private static final Reader EMPTY_STRING_READER = new StringReader("");
    private final AST ast;
    private final ISourceModule sourceModule;

    private ASTParser(Reader reader, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags) throws IOException {
        this(reader, phpVersion, useASPTags, useShortTags, null);
    }

    private ASTParser(Reader reader, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags, ISourceModule sourceModule) throws IOException {
        this.sourceModule = sourceModule;
        Object resource = null;
        if (sourceModule != null) {
            resource = sourceModule.getResource();
        }
        this.ast = new AST(reader, phpVersion, useASPTags, useShortTags, resource);
        this.ast.setDefaultNodeFlag(2);
    }

    public static ASTParser newParser(PHPVersion version, boolean useShortTags) {
        try {
            return new ASTParser(new StringReader(""), version, false, useShortTags);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    public static ASTParser newParser(PHPVersion version) {
        return ASTParser.newParser(version, true);
    }

    public static ASTParser newParser(PHPVersion version, ISourceModule sourceModule) {
        if (sourceModule == null) {
            throw new IllegalStateException("ASTParser - Can't parser with null ISourceModule");
        }
        try {
            ASTParser parser = new ASTParser(new StringReader(""), version, false, true, sourceModule);
            parser.setSource(sourceModule.getSourceAsCharArray());
            return parser;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEplPlugin.getDefault(), (String)"Error creating a new PHP AST Parser", (Throwable)e);
            return null;
        }
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useShortTags) throws IOException {
        return new ASTParser(reader, version, false, useShortTags);
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useASPTags, boolean useShortTags) throws IOException {
        return new ASTParser(reader, version, useASPTags, useShortTags);
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useASPTags, ISourceModule sourceModule) throws IOException {
        return new ASTParser(reader, version, useASPTags, true, sourceModule);
    }

    public void setSource(char[] source) throws IOException {
        CharArrayReader charArrayReader = new CharArrayReader(source);
        this.setSource(charArrayReader);
    }

    public void setSource(Reader source) throws IOException {
        this.ast.setSource(source);
    }

    public void setSource(ISourceModule sourceModule) throws IOException, CoreException {
        this.ast.setSource(new CharArrayReader(sourceModule.getSourceAsCharArray()));
    }

    public Program createAST(IProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask("Creating Abstract Syntax Tree for source...", 3);
        AstLexer lexer = this.ast.lexer();
        lr_parser phpParser = this.ast.parser();
        progressMonitor.worked(1);
        phpParser.setScanner((Scanner)lexer);
        progressMonitor.worked(2);
        Symbol symbol = phpParser.parse();
        progressMonitor.done();
        if (symbol == null || !(symbol.value instanceof Program)) {
            return null;
        }
        Program p = (Program)symbol.value;
        AST ast = p.getAST();
        p.setSourceModule(this.sourceModule);
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return p;
    }

    public AST getAST() {
        return this.ast;
    }

    private static PhpAstLexer createEmptyLexer_53() {
        return new PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer createEmptyLexer_54() {
        return new org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstParser createEmptyParser_54() {
        return new org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstParser(ASTParser.createEmptyLexer_54());
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser createEmptyParser_53() {
        return new org2.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser(ASTParser.createEmptyLexer_53());
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer createEmptyLexer_5() {
        return new org2.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static PhpAstParser createEmptyParser_5() {
        return new PhpAstParser(ASTParser.createEmptyLexer_5());
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer createEmptyLexer_4() {
        return new org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser createEmptyParser_4() {
        return new org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser(ASTParser.createEmptyLexer_4());
    }

    public static AstLexer getLexer(AST ast, Reader reader, PHPVersion phpVersion, boolean aspTagsAsPhp, boolean useShortTags, boolean createAST) throws IOException {
        if (ast == null) {
            ast = new AST(reader, phpVersion, aspTagsAsPhp, useShortTags);
            ast.setDefaultNodeFlag(2);
            return ast.lexer();
        }
        if (PHPVersion.PHP4 == phpVersion) {
            org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer lexer4 = ASTParser.getLexer4(reader);
            lexer4.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer4.setUseShortTags(useShortTags);
            lexer4.setAST(ast);
            return lexer4;
        }
        if (PHPVersion.PHP5 == phpVersion) {
            org2.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer lexer5 = ASTParser.getLexer5(reader);
            lexer5.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer5.setUseShortTags(useShortTags);
            lexer5.setAST(ast);
            return lexer5;
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            PhpAstLexer lexer53 = ASTParser.getLexer53(reader);
            lexer53.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer53.setUseShortTags(useShortTags);
            lexer53.setAST(ast);
            return lexer53;
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer lexer54 = ASTParser.getLexer54(reader);
            lexer54.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer54.setUseShortTags(useShortTags);
            lexer54.setAST(ast);
            return lexer54;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + (Object)((Object)phpVersion));
    }

    private static lr_parser getParser(PHPVersion phpVersion, AST ast) throws IOException {
        if (PHPVersion.PHP4 == phpVersion) {
            org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser parser = ASTParser.createEmptyParser_4();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5 == phpVersion) {
            PhpAstParser parser = ASTParser.createEmptyParser_5();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            org2.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser parser = ASTParser.createEmptyParser_53();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstParser parser = ASTParser.createEmptyParser_54();
            parser.setAST(ast);
            return parser;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + (Object)((Object)phpVersion));
    }

    private static PhpAstLexer getLexer53(Reader reader) throws IOException {
        PhpAstLexer phpAstLexer53 = ASTParser.createEmptyLexer_53();
        phpAstLexer53.yyreset(reader);
        phpAstLexer53.resetCommentList();
        return phpAstLexer53;
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer getLexer54(Reader reader) throws IOException {
        org2.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer phpAstLexer54 = ASTParser.createEmptyLexer_54();
        phpAstLexer54.yyreset(reader);
        phpAstLexer54.resetCommentList();
        return phpAstLexer54;
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer getLexer5(Reader reader) throws IOException {
        org2.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer phpAstLexer5 = ASTParser.createEmptyLexer_5();
        phpAstLexer5.yyreset(reader);
        phpAstLexer5.resetCommentList();
        return phpAstLexer5;
    }

    private static org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer getLexer4(Reader reader) throws IOException {
        org2.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer phpAstLexer4 = ASTParser.createEmptyLexer_4();
        phpAstLexer4.yyreset(reader);
        phpAstLexer4.resetCommentList();
        return phpAstLexer4;
    }
}

